package com.izenpe.zain.cliente.xades.multiples;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartSignRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartSignResponse;

public class GeneracionFirmaXMLEnvelopingBESSerie {
	// Nombre del fichero a utilizar para la generacin de la firma XADES-BES
	// Enveloping.
	private static final String fileName = "DemoSignedEnveloping.xml";

	public static void main(String[] args) {
		try {
			// Asignacin de la configuracin de forma programtica
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);
			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartSignRequest smartSignReq = new SmartSignRequest(Propiedades.ZAIN_ENDPOINT);

			//se indica que la firma es enveloping y el lugar dentro de la firma
			smartSignReq.setSignaturePlacement(Constants.SignaturePlacement.ENVELOPING);
			
			/*
			 * El atributo CounterSignatureXPath indica la ruta relativa, respecto al documento, en el que se
			 * encuentre la firma que tenga que firmarse en serie . Si dicho atributo no est presente, 
			 * se firmar la primera firma que contenga el elemento del documento, el atributo slo 
			 * puede estar ausente cuando documento slo contenga una firma).
			 */
			smartSignReq.setXmlCounterSignatureXPath("//dsig:Signature[not(child::*//xades:CounterSignature)]");

			// Se establece el perfil de firma XML (XADES) en la peticin de
			// Generacin de firma.
			smartSignReq.setProfile(Constants.Profile.XADES);
			
			// Se solicita que la firma sea de tipo XAdES-BES.
			smartSignReq.setSignatureFormat(Constants.SignatureFormat.BES);

			/*
			 * Se establece el idioma de la peticin en espaol. 2
			 * posibilidades: 1. Espaol: 'es' 2. Ingls: 'en'
			 */
			smartSignReq.setLanguage("es");

			// Certificado con el que realizar la firma.
			smartSignReq.setKeySubjectName(Propiedades.ZAIN_SIGNER);

			//se le indica que es una firma en serie
			smartSignReq.setXmlCounterSignature(true);

			/*
			 * True para obtener la firma en base64 (y evitar problemas con Axis
			 * al serializar y deserializar firmas XML).
			 */
			smartSignReq.setXmlReturnBase64(true);

			// Datos a firmar.
			smartSignReq.setInputXmlBase64(Base64.encode(ZainUtil.readBinaryFile("data/output/"
					+ fileName)));

			// Envo de la peticin.
			SmartSignResponse smartSignResp = smartSignReq.send();

			/*
			 * Se comprueba la validez de la respuesta y se escribe la respuesta
			 * de Generacin de firma XML en un fichero en disco.
			 */
			if (Constantes.RMAJOR_SUCCESS.equals((smartSignResp.getResultMajor()))
					&& smartSignResp.getResultMinor() == null) {
				String signXMLBase64 = smartSignResp.getSignatureXmlBase64();
				byte[] data = Base64.decode(signXMLBase64);
				String destFilename = "data/output/" + fileName.substring(0, fileName.lastIndexOf("."))
						+ "SignedEnveloping-Serie.xml";
				ZainUtil.writeBinaryFile(destFilename, data);
				System.out.println("La firma se ha generado con xito.");
			} else {
				System.out.println("Error en la Generacin de Firma:" + smartSignResp.getResultMessage());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}